s         o<     k  t                                            tplp        Thurlby-Thandar TPLP series PSU.              l    Thurlby-Thandar TPL----P series power supplies

This instrument module provides GPIB support for
the TPL----P series power supplies. Instruments in
this range meet the requirements of IEEE 488.2
standard. The module will be updated from time to
time as new instruments become available in the
range.

Instruments supported are:

PL330P        32 volt, 3 amp
PL330DP       32 volt, 3 amp Dual
PL330TP       32 volt, 3 amp Dual + 5 volt, 7 amp

The module contains the following functions:

1. Initialise.

2. Configuration
        1. Set Volts
        2. Set Current
        3. Set Output Status
        4. Set Meter Damping
        5. Output switch controls
        6. Status Reporting

3. Measurement and Status.
        1. Read Voltage
        2. Read Current
        3. Read Status

4. Miscellaneoue
        1. Send Command String
        2. Get Response String

5. Close                      Configuration Functions

These functions perform the complete set up of the
TPL----P power supply. The parameters are sent to
the instrument but the status is not checked so no
instrument errors will be reported. Status may be
read at any time with the read status function.
Available functions are listed below.

Set Voltage: Set voltage for each output.

Set Current: Set current for each output.

Set Output status: Set output status for each
                   output.

Set Meter damping: Set meter damping for each
                   output.

Output switch control: Set output switches on
                       or off.

Status reporting: Specify the way in which status
is reported and Service Request is generated as
defined in the IEEE 488.2 standard.
    |                Measurement and Status

These functions allow the voltage and current to
be read on each output and the status registers to
be interrogated. Available functions are as
follows.

Read Voltage: Reads the voltage from
the specified output.

Read Current: Reads the current from the selected
output.

Read status: Returns the byte value in the
selected status register.
    -                 Miscelaneous

These functions allow commands to be sent and
responses to be received which are not covered by
other panels in the instrument driver.

Any commands may be sent as a string of bytes.

Responses are received as a string of bytes for
later interrogation by the user program.        Panel name:     Initialise

Description:

 Initialises the TPL----P in the following way

        - opens the instrument and sets the GPIB
        address to the specified value.

        - sends device clear and clear status
        commands.

        - queries the instrument to determine the
        type/model number.

        - optionally sets the instrument to its
        default state.

    U    Control name:   GPIB Address

Description:    This control specifies the
                address used to communicate with
                the TPL----P power supply. It must
                correspond with the value set up
                at the instrument rear panel.

Variable type:  Integer

Valid range:    0 to 30

Default value:  11

    
     Control Name:  Instrument ID

 Description:   Returns an Instrument ID that is
                used in all subsequent function
                calls to select the instrument at
                the Address specified.

                If more than one instrument of the
                same type is used, this value will
                be used to differentiate between
                them. The first instrument
                initialized will be assigned an
                Instrument ID of 1.

 Variable Type: Integer    _    Control name:   Set Defaults

Description:    When set to Yes the parameters
                in the instrument will be set to
                their default values. If set to No
                the instrument settings will not
                be changed.

Variable type:  Integer

Valid range:    No = 0 , Yes = Any non-zero value

Default value:  No    S     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   GPIB Address out of range
       -2   Reset Device out of range

      220   Unable to open instrument
      221   Unable to close instrument
      223   Instrument identification query failed
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      240   Instrument timed out    R =            GPIB Address                       =$          Instrument ID                                 Set Defaults                      (          Error                                                                       (                                            11    	            Yes 1 No 0    	            (Instrument driver version 2.0 Apr. 1995    Copyright (c) TTi Ltd.    I    Panel name:     Set Volts

Description:

 Set voltage for each output.
    )    Control name:   Output Number

Description:    Indicates the output number to
                which the commands will be sent.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control name:   Voltage

Description:    The voltage value to which the
                specified output will be set. The
                value is expressed in Volts.

Variable type:  real

Valid range:    instrument dependent

    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    Z     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out     M           Output Number                      M         Voltage                                        Instrument ID                               Error                                         1 1 2 2 3 3        1    	            K    Panel name:     Set Current

Description:

 Set current for each output.
    )    Control name:   Output Number

Description:    Indicates the output number to
                which the commands will be sent.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control name:   Current

Description:    The current limit value to which
                the specified output will be set.
                The value is expressed in Amps.

Variable type:  real

Valid range:    instrument dependent


    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    Z     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out     M           Output Number                      M         Current                                        Instrument ID                      @          Error                                         1 1 2 2 3 3        1    	            d    Panel name:     Set Output status

Description:

 Set output status for each output to ON or OFF.
    )    Control name:   Output Number

Description:    Indicates the output number to
                which the commands will be sent.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control name:   Output Status

Description:    Specifies the status of the
                specified output.

Variable type:  integer

Valid range:    Off = 0 , On = 1

default value:  Off

    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range
       -3   Output status value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    # M           Output Number                     $C M          Output Status                     %             Instrument ID                     'k          Error                                         1 1 2 2 3 3   On 1 Off 0    1    	            n    Panel name:     Set Meter damping

Description:

 Set readback meter damping for each output to ON
 or OFF.
    )    Control name:   Output Number

Description:    Indicates the output number to
                which the commands will be sent.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control name:   Meter Damping

Description:    Specifies the dampimg applied to
                the current metering of the
                selected output.

Variable type:  integer

Valid range:    On = 1 , Off = 0

default value:  Off

    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range
       -3   Meter damping value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    *~ M           Output Number                     + M          Meter Damping                     ,             Instrument ID                     /          Error                                         1 1 2 2 3 3    on 1 Off 0    1    	            [    Panel name:     Output Switch Control

Description:

 Set all output switches on or off.
         Control name:   Master Output

Description:    Used to set the all outputs of the
                instrument on or off together.

Variable type:  integer

Valid range:    0 = OFF
                1 = ON

default value:  Off
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    `     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output switch value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    2 ]           Master Output                     2             Instrument ID                     5P          Error                              On 1 Off 0    1    	           -    Panel name:     Status Reporting

Description:

 Specify the way in which status is reported and
 Service Request is generated as defined in the
 IEEE 488.2 standard.

 The function provides access to the four status
 enable registers in the TPL----P power supply,
 these are:

 Service Request Enable Register

        - Specifies which bits, when set, in the
        Status Byte register will generate a
        Service Request.

 Standard Event Enable Register

        - Specifies which bits, when set, in the
        Standard Event Status register will set
        the ESB bit in the Status Byte Register.

 Limit Event Register

        - Specifies which bits, when set, in the
        Limit Event Status register will set the
        LIM bit in the Status Byte Register.

 Parallel Poll Enable Register

        - Specifies which bits, when set, in the
        Status Byte register will be used to form
        the ist local message

 See the IEEE 488.2 Standard and the instrument
 instruction book for a full description of status
 reporting capabilities.


    k    Control name:   Set Status Enable

Description:    Used to select which enable
                register will receive the byte
                value.

Variable type:  integer

Valid range:    0 = SRQ Enable
                1 = Standard Event Enable
                2 = Limit Event Enable
                3 = Parallel Poll Enable

Default value   0 (SRQ Enable)

         Control name:   Value

Description:    A byte value which will be written
                to the selected enable register.

Variable type:  integer

Valid range:    0 to 255

Default value:  0
    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Status enable value out of range
       -3   Byte value out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    ; ]           Set Status Enable                 = ]          Value                             =             Instrument ID                     @I          Error                                         :SRQ enable 0 Event Enable 1 Limit Enable 2 Parallel Pol 3    0    1    	            [    Panel name:     Read Volts

Description:

 Returns the Voltage from the selected output.
    )    Control name:   Output Number

Description:    Indicates the output number from
                which the values will be read.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control Name:   Output voltage

Description:    Voltage being output from the
                power supply.

Control Type:   Real.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out    Ck ]           Output Number                     D ]         Output Voltage                    E(             Instrument ID                     G          Error                                         1 1 2 2 3 3    	           1    	            ]    Panel name:     Read Current

Description:

 Returns the Current from the selected output.
    )    Control name:   Output Number

Description:    Indicates the output number from
                which the values will be read.

Variable type:  integer

Valid range:    min = 1 , max = number of outputs
                available for the particular
                instrument.

Default value   1
         Control Name:   Output current

Description:    Current being output by the power
                supply.

Control Type:   Real    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Output number out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out    J ]           Output Number                     K ]         Output Current                    L?             Instrument ID                     N          Error                                         1 1 2 2 3 3    	           1    	            x    Panel name:     Read Status

Description:    Returns the byte value from the
                selected status register.        Control name:   Read Status

Description:    Used to select which status
                register to read

Variable type:  integer

Valid range:    0 = Statue byte
                1 = Standard event
                2 = Limit event
                3 = ERQ enable
                4 = Event enable
                5 = Limit enable
                6 = Parallel poll enable

Default value   0 (Status Byte)

         Control Name:   Value

Description:    byte value of the
                selected register.

Control Type:   integer

Valid range:    0 to 255    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range
       -2   Register out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out    Q =           Read Status                       ST =+          Value                             S             Instrument ID                     VL          Error                                         bStatus byte 0 Std Event 1 Limit Event 2 SRQ enable 3 Event Enable 4 Limit Enable 5 Parallel Pol 6    	            1    	                Panel name:     Send command string

Description:    Sends a string of bytes to the
                TPL----P from a string variable.         Control name:   Command String

Description:    This control specifies data to be
                sent to the TPL----P. The absolute
                maximum length allowed is 2000
                bytes.

Variable type:  String


    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    3     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized
      240   Instrument timed out    Y =          Command String                    Z             Instrument ID                     ]          Error                              "*RST"    1    	                Panel name:     Get response string

Description:    Reads a response from the TPL----P
                into a string variable.        Control name:   Response Stirng

Description:    This control specifies a string
                variable to receive the response
                from the TPL----p. The string must
                be long enough to receive the
                response to avoid overflow. To aid
                in checking this the number of
                bytes put into the string is
                returned from the function. The
                absolute maximum length allowed is
                2000 bytes.

Variable type:  String
         Control name:   Number of Bytes

Description:    This value is the number of bytes
                returned by the TPL----P and
                placed in the string.

Variable type:  Integer    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.    ]     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      240   Instrument timed out    _ =          Response String                   a =9          Number of Bytes                   bk             Instrument ID                     d          Error                              	            	            1    	                Panel name:     Close

Description:    Takes the instrument off-line.
                The  instrument must  be
                reinitialized to use it again.    X     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1 to  Maximum Instances of
                      this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                of instruments that can be
                controlled by this driver in a
                single system. The value is set
                internally in the driver. The
                typical value is 10.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success

       -1   Instrument ID out of range

      221   Unable to close instrument
      232   Instrument not initialized    g             Instrument ID                     j4          Error                              1    	                  	       K.    init                                     2  d     K.    set_volts                                h  !     K.    set_current                              "  (     K.    set_op_stat                              *  0     K.    set_damping                              1  6     K.    op_switch                                7v  A     K.    set_status                               C  I     K.    read_op_volts                            J   P+     K.    read_op_current                          Q7  W     K.    read_status                              Y5  ^M     K.    send_cmd                                 _  f0     K.    get_response                             g-  kM     K.    close                                                                       DInitialise                          Configure                            DSet Volts                            DSet Current                          DSet Output Status                    DSet Meter Damping                    DOutput Switch Control                DStatus Reporting                    Measurement and Status               DRead Output Volts                    DRead Output Current                  DRead Status                         Miscellaneous                        DSend Command String                  DGet Response String                  DClose                           